﻿using System;
using Microsoft.SharePoint.Client;

class Program
{
   static void Main(string[] args)
   {
      // Neues ClientContext-Objekt erzeugen
      ClientContext ctx = new ClientContext("http://contoso.de");

      // Web und List-Objekt erzeugen
      Web web = ctx.Web;
      ListCollection allLists = web.Lists;

      // Objekte laden
      ctx.Load(web,
         w => w.Title,
         w => w.ServerRelativeUrl);

      ctx.Load(allLists,
         lists => lists.Include(
            l => l.Title,
            l => l.BaseType));

      // Anfrage zum Server senden
      ctx.ExecuteQuery();

      // Daten ausgeben
      Console.WriteLine("Website: {0} (URL: {1})",
         web.Title,
         web.ServerRelativeUrl);

      foreach (List list in allLists)
      {
         Console.WriteLine("Liste: {0} (Typ: {1})",
            list.Title,
            list.BaseType);
      }
   }
}